﻿© Fluke. All Rights Reserved.                               MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub IVI Constants
DATE:                  2011-07-25 09:23:15
AUTHOR:                Fluke
REVISION:              $Revision: 1.1 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       227
=============================================================================
#
# Text Source:
#   $RCSfile: sub_ivi_constants.txt,v $
#   $Date: 2011/08/03 22:45:54 $
#
# Procedure Author(s):
#       DAC
#
# Source:
#       I V I
#       ©1998-2003 National Instruments.  All Rights Reserved.
#       Title:       ivi.h
#       Purpose:     Declarations for the Interchangeable Virtual Instruments
#                    (IVI) Library.
#
# Compatibility:
#       MET/CAL 8.0
#
#  Subprocedures:
#       None
#
#  Required Files:
#       None
#
#  Additional Equipment Required:
#       None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

#****************************************************************************/
#* Useful constants                                                ======== */
#****************************************************************************/
  1.001  MATH         @iviEngineMajorVer = 4
  1.002  MATH         @iviEngineMinorVer = 100

  1.003  MATH         @iviVIReal64Max = 1.79769313486231570814527423732e+308
  1.004  MATH         @iviVIReal64MaxNeg = -1 * @iviVIReal64Max

#* Defined values for powerline frequency */
  1.005  MATH         @iviVal50Hz  = 50.0
  1.006  MATH         @iviVal60Hz  = 60.0
  1.007  MATH         @iviVal400Hz = 400.0

#* Defined values for I/O Session Type    */
  1.008  MATH         @iviValVISASessionType     = "VISA"
  1.009  MATH         @iviValNI4882SessionType   = "NI-488.2"
  1.010  MATH         @iviValNIVXISessionType    = "NI-VXI"
  1.011  MATH         @iviValNIDAQSessionType    = "NI-DAQ"
  1.012  MATH         @iviValNISerialSessionType = "NI-Serial"

  1.013  MATH         @iviMaxMesgLen     = 255
  1.014  MATH         @iviMaxMesgBufSize = @iviMaxMesgLen + 1

  1.015  MATH         @iviValNoWait      = 0
  1.016  MATH         @iviValWaitForever = @iviVIReal64Max

# 1.017  MATH         @iviValMaxTimeInfinite  = viTimeoutInfinite
# 1.018  MATH         @iviValMaxTimeImmediate = viTimeoutImmediate

  1.017  MATH         @iviMaxPathNameLen  = 260
  1.018  MATH         @iviMaxDriveNameLen = 3
  1.019  MATH         @iviMaxDirNameLen   = 256
  1.020  MATH         @iviMaxFileNameLen  = 256

#****************************************************************************/

  1.021  MATH         @iviValTypeNormal = 0
  1.022  MATH         @iviValTypeNAN    = 1
  1.023  MATH         @iviValTypePosInf = 2
  1.024  MATH         @iviValTypeNegInf = 3

#****************************************************************************/
#*  Interchange Warning Codes: The Ivi_GetNextInterchangeWarning function   */
#*  returns these values to identify the type of interchangeability warning.*/
#****************************************************************************/

  1.025  MATH         @iviValNotInUserSpecState             = 1
  1.026  MATH         @iviValReadOnlyAttrSetByUseR          = 2
  1.027  MATH         @iviValAttrSetToInstrSpecVal          = 3
#        MATH         @iviValFailureApplyingUnusedExtension = 4
#        MATH         @iviValClassDefinedInterchangeWarning = 5

#****************************************************************************/
#*= Typedefs and related constants for the range tables            ======== */
#****************************************************************************/

#* Defined values for the type of IviRngTable */
  1.028  MATH         @iviValDiscrete = 0
  1.029  MATH         @iviValRngD   = 1
  1.030  MATH         @iviValCoerceD  = 2

#****************************************************************************/
#*= Constants for channels.                                       ========= */
#****************************************************************************/
  1.031  MATH         @iviValAllChans     = "IVI_ALL_CHANNELS"
  1.032  MATH         @iviValAllInstances = @iviValAllChans

  1.033  MATH         @iviValInt32       = 1
  1.034  MATH         @iviValInt64       = 2
  1.035  MATH         @iviValReal64      = 4
  1.036  MATH         @iviValString      = 5
  1.037  MATH         @iviValAddr        = 10
  1.038  MATH         @iviValSession     = 11
  1.039  MATH         @iviValBoolean     = 13
  1.040  MATH         @iviValUnknownType = 14

#****************************************************************************/
#*= Constants for the Ivi_ReadToFile function.                    ========= */
#****************************************************************************/
#* fileAction */
  1.041  MATH         @iviValTruncate = 1
  1.042  MATH         @iviValAppend   = 2

#****************************************************************************/
#*= Constants for the Ivi_PerformClassInterchangeCheck function.        === */
#****************************************************************************/
#* IVI Class API */
  1.043  MATH         @iviValClassAPI_DCPWR = 1
  1.044  MATH         @iviValClassAPI_DMM   = 2
  1.045  MATH         @iviValClassAPI_FGEN  = 3
  1.046  MATH         @iviValClassAPI_SCOPE = 4
  1.047  MATH         @iviValClassAPI_SWTCH = 5

#****************************************************************************/
#*= Base values for attribute contants.                            ======== */
#*= A private attribute is one that is defined for use within      ======== */
#*= that module and is not exported via an include file.           ======== */
#****************************************************************************/
  1.048  MATH         @iviAttrBase              = 1000000

  1.049  MATH         @iviEnginePrivateAttrBase = @iviAttrBase +  00000
  1.050  MATH         @iviEnginePublicAttrBase  = @iviAttrBase +  50000
  1.051  MATH         @iviSpecPrivateAttrBase   = @iviAttrBase + 100000
  1.052  MATH         @iviSpecPublicAttrBase    = @iviAttrBase + 150000
  1.053  MATH         @iviClassPrivateAttrBase  = @iviAttrBase + 200000
  1.054  MATH         @iviClassPublicAttrBase   = @iviAttrBase + 250000

#****************************************************************************/
#*= Public IVI engine attributes                                   ======== */
#*= The data type of each attribute is listed, followed by the     ======== */
#*= default value or a remark.                                     ======== */
#*= Note:  "hidden" means not readable or writable by the end-user.======== */
#****************************************************************************/
  1.055  MATH         AttrBase = @iviEnginePublicAttrBase

  1.056  MATH         @iviAttrRngChk         = AttrBase + 2
  1.057  MATH         @iviAttrQueryInstrStat = AttrBase + 3
  1.058  MATH         @iviAttrCache          = AttrBase + 4
  1.059  MATH         @iviAttrSim            = AttrBase + 5
  1.060  MATH         @iviAttrRecCoercions   = AttrBase + 6
  1.061  MATH         @iviAttrDrvSetup       = AttrBase + 7

  1.062  MATH         @iviAttrInterchangeChk = AttrBase + 21
  1.063  MATH         @iviAttrSpy            = AttrBase + 22
  1.064  MATH         @iviAttrUseSpecSim     = AttrBase + 23

  1.065  MATH         @iviAttrPrimaryErr     = AttrBase + 101
  1.066  MATH         @iviAttrSecondaryErr   = AttrBase + 102
  1.067  MATH         @iviAttrErrElaboration = AttrBase + 103

  1.068  MATH         @iviAttrChanCount = AttrBase + 203

  1.069  MATH         @iviAttrClassDrvPrefix       = AttrBase + 301
  1.070  MATH         @iviAttrSpecificDrvPrefix    = AttrBase + 302
  1.071  MATH         @iviAttrSpecificDrvLocator   = AttrBase + 303
  1.072  MATH         @iviAttrIOResourceDescriptor = AttrBase + 304
  1.073  MATH         @iviAttrLogicalName          = AttrBase + 305
  1.074  MATH         @iviAttrVisaRMSession        = AttrBase + 321
  1.075  MATH         @iviAttrIOSession            = AttrBase + 322
  1.076  MATH         @iviAttrIOSessionType        = AttrBase + 324
  1.077  MATH         @iviAttrSupportedInstrModels = AttrBase + 327

  1.078  MATH         @iviAttrGroupCapabilities = AttrBase + 401
  1.079  MATH         @iviAttrFuncCapabilities  = AttrBase + 402

  1.080  MATH         @iviAttrEngineMajorVer      = AttrBase + 501
  1.081  MATH         @iviAttrEngineMinorVer      = AttrBase + 502
  1.082  MATH         @iviAttrSpecificDrvMajorVer = AttrBase + 503
  1.083  MATH         @iviAttrSpecificDrvMinorVer = AttrBase + 504
  1.084  MATH         @iviAttrClassDrvMajorVer    = AttrBase + 505
  1.085  MATH         @iviAttrClassDrvMinorVer    = AttrBase + 506

  1.086  MATH         @iviAttrInstrFirmwareRev          = AttrBase + 510
  1.087  MATH         @iviAttrInstrManufacturer         = AttrBase + 511
  1.088  MATH         @iviAttrInstrModel                = AttrBase + 512
  1.089  MATH         @iviAttrSpecificDrvVendor         = AttrBase + 513
  1.090  MATH         @iviAttrSpecificDrvDescr          = AttrBase + 514
# 1.091  MATH         @iviAttrSpecificDrvClassSpecMajorVer = AttrBase + 515
# 1.092  MATH         @iviAttrSpecificDrvClassSpecMinorVer = AttrBase + 516
  1.091  MATH         @iviAttrClassDrvVendor            = AttrBase + 517
  1.092  MATH         @iviAttrClassDrvDescr             = AttrBase + 518
#        MATH         @iviAttrClassDrvClassSpecMajorVer = AttrBase + 519
#        MATH         @iviAttrClassDrvClassSpecMinorVer = AttrBase + 520

  1.093  MATH         @iviAttrSpecificDrvRev = AttrBase + 551
  1.094  MATH         @iviAttrClassDrvRev    = AttrBase + 552
  1.095  MATH         @iviAttrEngineRev      = AttrBase + 553

  1.096  MATH         @iviAttrOPCCallback     = AttrBase + 602
  1.097  MATH         @iviAttrChkStatCallback = AttrBase + 603

#        NATH         @iviAttrUserInterchangeChkCallback = AttrBase + 801

  1.098  END
